/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.world.MockWorld;
import ivorius.reccomplex..shadow.mcopts.commands.CommandSplit;
import ivorius.reccomplex..shadow.mcopts.commands.SimpleCommand;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.capability.SelectionOwner;
import ivorius.reccomplex.commands.CommandVirtual;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandSelection
extends CommandSplit
implements CommandVirtual {
    public ICommand set;

    public CommandSelection() {
        this.add(new Command("clear"){

            @Override
            public void execute(MockWorld world, ICommandSender sender, Parameters parameters, SelectionOwner owner) throws CommandException {
                owner.setSelection(null);
            }
        });
        this.add(new Command("get"){

            @Override
            public void execute(MockWorld world, ICommandSender sender, Parameters parameters, SelectionOwner owner) throws CommandException {
                sender.func_145747_a(RecurrentComplex.translations.format("commands.selectSet.get", RCTextStyle.area(owner.getSelection())));
                if (owner.hasValidSelection()) {
                    sender.func_145747_a(RecurrentComplex.translations.format("commands.selectSet.size", RCTextStyle.size(owner.getSelection().areaSize()), IvVecMathHelper.product((int[])owner.getSelection().areaSize())));
                }
            }
        });
        this.set = new Command("set", expect -> expect.then(MCE::xyz).then(MCE::xyz).required().flag("first", new String[0]).flag("second", new String[0])){

            @Override
            public void execute(MockWorld world, ICommandSender sender, Parameters parameters, SelectionOwner owner) throws CommandException {
                boolean first = !parameters.has("second");
                boolean second = !parameters.has("first");
                boolean shiftSecond = false;
                if (!first && !second) {
                    shiftSecond = true;
                    first = true;
                    second = true;
                }
                if (first) {
                    if (owner.getSelectedPoint1() == null) {
                        owner.setSelectedPoint1(sender.func_180425_c());
                    }
                    owner.setSelectedPoint1((BlockPos)parameters.get(0).to(MCP.pos(owner.getSelectedPoint1(), false)).require());
                }
                if (second) {
                    if (owner.getSelectedPoint2() == null) {
                        owner.setSelectedPoint2(sender.func_180425_c());
                    }
                    owner.setSelectedPoint2((BlockPos)parameters.get(shiftSecond ? 3 : 0).to(MCP.pos(owner.getSelectedPoint2(), false)).require());
                }
            }
        };
        this.add(this.set);
        this.add(new Command("crop", expect -> expect.then(MCE::block).descriptionU("positioned block expression")){

            @Override
            public void execute(MockWorld world, ICommandSender sender, Parameters parameters, SelectionOwner owner) throws CommandException {
                RCCommands.ensureValidSelection(owner, false);
                BlockArea area = owner.getSelection();
                PositionedBlockExpression matcher = (PositionedBlockExpression)parameters.get(0).rest(NaP::join).orElse("is:air").to(RCP::expression, new PositionedBlockExpression(RecurrentComplex.specialRegistry)).require();
                for (EnumFacing direction : EnumFacing.field_82609_l) {
                    while (area != null && CommandSelection.sideStream(area, direction).allMatch(p -> matcher.test(PositionedBlockExpression.Argument.at(world, p)))) {
                        area = BlockAreas.shrink((BlockArea)area, (EnumFacing)direction, (int)1);
                    }
                }
                owner.setSelection(area);
            }
        });
        this.add(new Command("wand", expect -> expect.then(MCE::block).descriptionU("positioned block expression")){

            @Override
            public void execute(MockWorld world, ICommandSender sender, Parameters parameters, SelectionOwner owner) throws CommandException {
                RCCommands.ensureValidSelection(owner, true);
                BlockArea area = owner.getSelection();
                boolean changed = true;
                int total = 0;
                while (changed) {
                    changed = false;
                    PositionedBlockExpression matcher = (PositionedBlockExpression)parameters.get(0).rest(NaP::join).orElse("!is:air").to(RCP::expression, new PositionedBlockExpression(RecurrentComplex.specialRegistry)).require();
                    for (EnumFacing direction : EnumFacing.field_82609_l) {
                        BlockArea expand;
                        while (CommandSelection.sideStream(expand = BlockAreas.expand((BlockArea)area, (EnumFacing)direction, (int)1), direction).anyMatch(p -> matcher.test(PositionedBlockExpression.Argument.at(world, p))) && total++ < 300) {
                            area = expand;
                            changed = true;
                        }
                    }
                }
                owner.setSelection(area);
            }
        });
        this.add(new Command("shrink", expect -> expect.any("1", "2", "3").descriptionU("all").named("x", new String[0]).any("1", "2", "3").descriptionU("x").named("y", new String[0]).any("1", "2", "3").descriptionU("y").named("z", new String[0]).any("1", "2", "3").descriptionU("z")){

            @Override
            public void execute(MockWorld world, ICommandSender sender, Parameters parameters, SelectionOwner owner) throws CommandException {
                RCCommands.ensureValidSelection(owner, false);
                BlockPos base = (BlockPos)parameters.get(0).to(MCP.pos(parameters.get(0), parameters.get(0), BlockPos.field_177992_a, false)).require();
                BlockPos shrink = (BlockPos)parameters.get(MCP.pos("x", "y", "z", base, false)).require();
                owner.setSelection(BlockAreas.shrink((BlockArea)owner.getSelection(), (BlockPos)shrink, (BlockPos)shrink));
            }
        });
        this.add(new Command("expand", expect -> expect.any("1", "2", "3").descriptionU("all").named("x", new String[0]).any("1", "2", "3").descriptionU("x").named("y", new String[0]).any("1", "2", "3").descriptionU("y").named("z", new String[0]).any("1", "2", "3").descriptionU("z")){

            @Override
            public void execute(MockWorld world, ICommandSender sender, Parameters parameters, SelectionOwner owner) throws CommandException {
                RCCommands.ensureValidSelection(owner, true);
                BlockPos base = (BlockPos)parameters.get(0).to(MCP.pos(parameters.get(0), parameters.get(0), BlockPos.field_177992_a, false)).require();
                BlockPos shrink = (BlockPos)parameters.get(MCP.pos("x", "y", "z", base, false)).require();
                owner.setSelection(BlockAreas.expand((BlockArea)owner.getSelection(), (BlockPos)shrink, (BlockPos)shrink));
            }
        });
        this.permitFor(2);
    }

    @Nonnull
    protected static Stream<BlockPos> sideStream(BlockArea area, EnumFacing direction) {
        return StreamSupport.stream(BlockAreas.side((BlockArea)area, (EnumFacing)direction).spliterator(), false);
    }

    @Override
    public String func_71517_b() {
        return RCConfig.commandPrefix + "selection";
    }

    @Override
    public void execute(MockWorld world, ICommandSender sender, String[] args) throws CommandException {
        MinecraftServer server = sender.func_184102_h();
        ICommand command = this.validatedCommand(server, sender, args);
        if (!(command instanceof CommandVirtual)) {
            throw RecurrentComplex.translations.commandException("commands.rcmap.nonvirtual", new Object[0]);
        }
        CommandVirtual virtual = (CommandVirtual)command;
        virtual.execute(world, sender, this.splitParameters(args));
    }

    public static abstract class Command
    extends SimpleCommand
    implements CommandVirtual {
        public Command(String name) {
            super(name);
        }

        public Command(String name, Consumer<Expect> expector) {
            super(name, expector);
        }

        public Command(String name, String usage, Consumer<Expect> expector) {
            super(name, usage, expector);
        }

        @Override
        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            SelectionOwner owner = RCCommands.getSelectionOwner(sender, null, false);
            Parameters parameters = Parameters.of(args, this.expect()::declare);
            this.execute((MockWorld)MockWorld.of((World)sender.func_130014_f_()), sender, parameters, owner);
        }

        @Override
        public void execute(MockWorld world, ICommandSender sender, String[] args) throws CommandException {
            SelectionOwner owner = RCCommands.getSelectionOwner(sender, null, false);
            Parameters parameters = Parameters.of(args, this.expect()::declare);
            this.execute(world, sender, parameters, owner);
        }

        public abstract void execute(MockWorld var1, ICommandSender var2, Parameters var3, SelectionOwner var4) throws CommandException;
    }
}

